-- djangoar13x.bumenxinxi definition
DROP DATABASE IF EXISTS djangoar13x;

CREATE DATABASE djangoar13x default character set utf8mb4 collate utf8mb4_general_ci;

USE djangoar13x;

CREATE TABLE "bumenxinxi" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "bumenmingcheng" varchar(200) NOT NULL COMMENT '部门名称',
  "bumenzhuguan" varchar(200) NOT NULL COMMENT '部门主管',
  "bumenrenshu" int(11) NOT NULL COMMENT '部门人数',
  "bumenzhize" longtext COMMENT '部门职责',
  "riqi" date DEFAULT NULL COMMENT '日期',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COMMENT='部门信息';


-- djangoar13x.config definition

CREATE TABLE "config" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "name" varchar(100) NOT NULL COMMENT '配置参数名称',
  "value" varchar(100) DEFAULT NULL COMMENT '配置参数值',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='配置文件';


-- djangoar13x.fulixinxi definition

CREATE TABLE "fulixinxi" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "fulimingcheng" varchar(200) NOT NULL COMMENT '福利名称',
  "jine" int(11) NOT NULL COMMENT '金额',
  "fulineirong" longtext COMMENT '福利内容',
  "riqi" date DEFAULT NULL COMMENT '日期',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8 COMMENT='福利信息';


-- djangoar13x.gongzixinxi definition

CREATE TABLE "gongzixinxi" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "mingcheng" varchar(200) NOT NULL COMMENT '名称',
  "riqi" date DEFAULT NULL COMMENT '日期',
  "gonghao" varchar(200) DEFAULT NULL COMMENT '工号',
  "xingming" varchar(200) DEFAULT NULL COMMENT '姓名',
  "bumen" varchar(200) DEFAULT NULL COMMENT '部门',
  "jibengongzi" varchar(200) NOT NULL COMMENT '基本工资',
  "jiabangongzi" varchar(200) NOT NULL COMMENT '加班工资',
  "fuli" varchar(200) DEFAULT NULL COMMENT '福利',
  "jine" varchar(200) DEFAULT NULL COMMENT '金额',
  "shebao" varchar(200) NOT NULL COMMENT '社保',
  "gongjijin" varchar(200) NOT NULL COMMENT '公积金',
  "chuqinkoufei" varchar(200) NOT NULL COMMENT '出勤扣费',
  "suodeshui" varchar(200) NOT NULL COMMENT '所得税',
  "shifagongzi" varchar(200) DEFAULT NULL COMMENT '实发工资',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8 COMMENT='工资信息';


-- djangoar13x.jiabanxinxi definition

CREATE TABLE "jiabanxinxi" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "mingcheng" varchar(200) NOT NULL COMMENT '名称',
  "riqi" date DEFAULT NULL COMMENT '日期',
  "gonghao" varchar(200) DEFAULT NULL COMMENT '工号',
  "xingming" varchar(200) DEFAULT NULL COMMENT '姓名',
  "bumen" varchar(200) DEFAULT NULL COMMENT '部门',
  "shangbanshijian" varchar(200) DEFAULT NULL COMMENT '上班时间',
  "xiabanshijian" varchar(200) DEFAULT NULL COMMENT '下班时间',
  "jiabanfeiyong" float NOT NULL COMMENT '加班费用',
  "jiabanshizhang" float NOT NULL COMMENT '加班时长',
  "jiabangongzi" float NOT NULL COMMENT '加班工资',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=1648737606478 DEFAULT CHARSET=utf8 COMMENT='加班信息';


-- djangoar13x.kaoqinxinxi definition

CREATE TABLE "kaoqinxinxi" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "biaoti" varchar(200) NOT NULL COMMENT '标题',
  "gonghao" varchar(200) DEFAULT NULL COMMENT '工号',
  "xingming" varchar(200) DEFAULT NULL COMMENT '姓名',
  "bumen" varchar(200) DEFAULT NULL COMMENT '部门',
  "kaoqinzhuangkuang" varchar(200) DEFAULT NULL COMMENT '考勤状况',
  "queqincishu" varchar(200) DEFAULT NULL COMMENT '缺勤次数',
  "beizhu" longtext COMMENT '备注',
  "riqi" date DEFAULT NULL COMMENT '日期',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8 COMMENT='考勤信息';


-- djangoar13x.lizhixinxi definition

CREATE TABLE "lizhixinxi" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "mingcheng" varchar(200) NOT NULL COMMENT '名称',
  "cizhiriqi" date DEFAULT NULL COMMENT '辞职日期',
  "liyou" longtext COMMENT '理由',
  "cizhibiao" varchar(200) DEFAULT NULL COMMENT '辞职表',
  "gonghao" varchar(200) DEFAULT NULL COMMENT '工号',
  "xingming" varchar(200) DEFAULT NULL COMMENT '姓名',
  "bumen" varchar(200) DEFAULT NULL COMMENT '部门',
  "sfsh" varchar(200) DEFAULT '否' COMMENT '是否审核',
  "shhf" longtext COMMENT '审核回复',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8 COMMENT='离职信息';


-- djangoar13x.qingjiaxinxi definition

CREATE TABLE "qingjiaxinxi" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "mingcheng" varchar(200) NOT NULL COMMENT '名称',
  "qingjiariqi" date DEFAULT NULL COMMENT '请假日期',
  "qingjiatianshu" varchar(200) NOT NULL COMMENT '请假天数',
  "qingjianeirong" longtext COMMENT '请假内容',
  "gonghao" varchar(200) DEFAULT NULL COMMENT '工号',
  "xingming" varchar(200) DEFAULT NULL COMMENT '姓名',
  "bumen" varchar(200) DEFAULT NULL COMMENT '部门',
  "sfsh" varchar(200) DEFAULT '否' COMMENT '是否审核',
  "shhf" longtext COMMENT '审核回复',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 COMMENT='请假信息';


-- djangoar13x.renshidiaodong definition

CREATE TABLE "renshidiaodong" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "mingcheng" varchar(200) NOT NULL COMMENT '名称',
  "riqi" date DEFAULT NULL COMMENT '日期',
  "gonghao" varchar(200) DEFAULT NULL COMMENT '工号',
  "bumen" varchar(200) DEFAULT NULL COMMENT '部门',
  "xingming" varchar(200) DEFAULT NULL COMMENT '姓名',
  "diaodongneirong" longtext COMMENT '调动内容',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8 COMMENT='人事调动';


-- djangoar13x.renyuandangan definition

CREATE TABLE "renyuandangan" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "danganbianhao" varchar(200) NOT NULL COMMENT '档案编号',
  "mingcheng" varchar(200) NOT NULL COMMENT '名称',
  "gonghao" varchar(200) DEFAULT NULL COMMENT '工号',
  "xingming" varchar(200) DEFAULT NULL COMMENT '姓名',
  "xingbie" varchar(200) DEFAULT NULL COMMENT '性别',
  "nianling" varchar(200) DEFAULT NULL COMMENT '年龄',
  "bumen" varchar(200) DEFAULT NULL COMMENT '部门',
  "dengji" varchar(200) DEFAULT NULL COMMENT '等级',
  "gongling" varchar(200) DEFAULT NULL COMMENT '工龄',
  "dianhua" varchar(200) DEFAULT NULL COMMENT '电话',
  "zhuzhi" varchar(200) DEFAULT NULL COMMENT '住址',
  "ruzhiriqi" date DEFAULT NULL COMMENT '入职日期',
  "shengzhidiaodong" longtext COMMENT '升职调动',
  "beizhu" longtext COMMENT '备注',
  "dengjiriqi" date DEFAULT NULL COMMENT '登记日期',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='人员档案';


-- djangoar13x.shangbandaka definition

CREATE TABLE "shangbandaka" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "mingcheng" varchar(200) NOT NULL COMMENT '名称',
  "shangbanshijian" datetime DEFAULT NULL COMMENT '上班时间',
  "xiabanshijian" datetime DEFAULT NULL COMMENT '下班时间',
  "gonghao" varchar(200) DEFAULT NULL COMMENT '工号',
  "xingming" varchar(200) DEFAULT NULL COMMENT '姓名',
  "bumen" varchar(200) DEFAULT NULL COMMENT '部门',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COMMENT='上班打卡';


-- djangoar13x.users definition

CREATE TABLE "users" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "username" varchar(100) NOT NULL COMMENT '用户名',
  "password" varchar(100) NOT NULL COMMENT '密码',
  "role" varchar(100) DEFAULT '管理员' COMMENT '角色',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  PRIMARY KEY ("id")
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='用户表';


-- djangoar13x.yuangong definition

CREATE TABLE "yuangong" (
  "id" bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  "addtime" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  "gonghao" varchar(200) NOT NULL COMMENT '工号',
  "mima" varchar(200) NOT NULL COMMENT '密码',
  "xingming" varchar(200) DEFAULT NULL COMMENT '姓名',
  "xingbie" varchar(200) DEFAULT NULL COMMENT '性别',
  "nianling" varchar(200) DEFAULT NULL COMMENT '年龄',
  "touxiang" varchar(200) DEFAULT NULL COMMENT '头像',
  "bumen" varchar(200) DEFAULT NULL COMMENT '部门',
  "dianhua" varchar(200) DEFAULT NULL COMMENT '电话',
  "zhuzhi" varchar(200) DEFAULT NULL COMMENT '住址',
  PRIMARY KEY ("id"),
  UNIQUE KEY "gonghao" ("gonghao")
) ENGINE=InnoDB AUTO_INCREMENT=1648734691397 DEFAULT CHARSET=utf8 COMMENT='员工';



INSERT INTO djangoar13x.bumenxinxi (addtime,bumenmingcheng,bumenzhuguan,bumenrenshu,bumenzhize,riqi) VALUES
	 ('2022-03-24 11:35:12','部门名称1','部门主管1',1,'部门职责1','2022-03-24'),
	 ('2022-03-24 11:35:12','部门名称2','部门主管2',2,'部门职责2','2022-03-24'),
	 ('2022-03-24 11:35:12','部门名称3','部门主管3',3,'部门职责3','2022-03-24'),
	 ('2022-03-24 11:35:12','部门名称4','部门主管4',4,'部门职责4','2022-03-24'),
	 ('2022-03-24 11:35:12','部门名称5','部门主管5',5,'部门职责5','2022-03-24'),
	 ('2022-03-24 11:35:12','部门名称6','部门主管6',6,'部门职责6','2022-03-24');INSERT INTO djangoar13x.config (name,value) VALUES
	 ('picture1','http://localhost:8080/djangoar13x/upload/picture1.jpg'),
	 ('picture2','http://localhost:8080/djangoar13x/upload/picture2.jpg'),
	 ('picture3','http://localhost:8080/djangoar13x/upload/picture3.jpg'),
	 ('homepage',NULL);INSERT INTO djangoar13x.fulixinxi (addtime,fulimingcheng,jine,fulineirong,riqi) VALUES
	 ('2022-03-24 11:35:12','福利名称1',1,'福利内容1','2022-03-24'),
	 ('2022-03-24 11:35:12','福利名称2',2,'福利内容2','2022-03-24'),
	 ('2022-03-24 11:35:12','福利名称3',3,'福利内容3','2022-03-24'),
	 ('2022-03-24 11:35:12','福利名称4',4,'福利内容4','2022-03-24'),
	 ('2022-03-24 11:35:12','福利名称5',5,'福利内容5','2022-03-24'),
	 ('2022-03-24 11:35:12','福利名称6',6,'福利内容6','2022-03-24');INSERT INTO djangoar13x.gongzixinxi (addtime,mingcheng,riqi,gonghao,xingming,bumen,jibengongzi,jiabangongzi,fuli,jine,shebao,gongjijin,chuqinkoufei,suodeshui,shifagongzi) VALUES
	 ('2022-03-24 11:35:12','名称1','2022-03-24','工号1','姓名1','部门1','基本工资1','加班工资1','福利1','金额1','社保1','公积金1','出勤扣费1','所得税1','实发工资1'),
	 ('2022-03-24 11:35:12','名称2','2022-03-24','工号2','姓名2','部门2','基本工资2','加班工资2','福利2','金额2','社保2','公积金2','出勤扣费2','所得税2','实发工资2'),
	 ('2022-03-24 11:35:12','名称3','2022-03-24','工号3','姓名3','部门3','基本工资3','加班工资3','福利3','金额3','社保3','公积金3','出勤扣费3','所得税3','实发工资3'),
	 ('2022-03-24 11:35:12','名称4','2022-03-24','工号4','姓名4','部门4','基本工资4','加班工资4','福利4','金额4','社保4','公积金4','出勤扣费4','所得税4','实发工资4'),
	 ('2022-03-24 11:35:12','名称5','2022-03-24','工号5','姓名5','部门5','基本工资5','加班工资5','福利5','金额5','社保5','公积金5','出勤扣费5','所得税5','实发工资5'),
	 ('2022-03-24 11:35:12','名称6','2022-03-24','工号6','姓名6','部门6','基本工资6','加班工资6','福利6','金额6','社保6','公积金6','出勤扣费6','所得税6','实发工资6');INSERT INTO djangoar13x.jiabanxinxi (addtime,mingcheng,riqi,gonghao,xingming,bumen,shangbanshijian,xiabanshijian,jiabanfeiyong,jiabanshizhang,jiabangongzi) VALUES
	 ('2022-03-24 11:35:12','名称1','2022-03-24','工号1','姓名1','部门1','上班时间1','下班时间1',1.0,1.0,1.0),
	 ('2022-03-24 11:35:12','名称2','2022-03-24','工号2','姓名2','部门2','上班时间2','下班时间2',2.0,2.0,2.0),
	 ('2022-03-24 11:35:12','名称3','2022-03-24','工号3','姓名3','部门3','上班时间3','下班时间3',3.0,3.0,3.0),
	 ('2022-03-24 11:35:12','名称4','2022-03-24','工号4','姓名4','部门4','上班时间4','下班时间4',4.0,4.0,4.0),
	 ('2022-03-24 11:35:12','名称5','2022-03-24','工号5','姓名5','部门5','上班时间5','下班时间5',5.0,5.0,5.0),
	 ('2022-03-24 11:35:12','名称6','2022-03-24','工号6','姓名6','部门6','上班时间6','下班时间6',6.0,6.0,6.0),
	 ('2022-03-31 22:40:06','名称1',NULL,'工号1','姓名1','部门1','2022-03-24T11:35:12Z','2022-03-24T11:35:12Z',20.0,1.0,20.0);INSERT INTO djangoar13x.kaoqinxinxi (addtime,biaoti,gonghao,xingming,bumen,kaoqinzhuangkuang,queqincishu,beizhu,riqi) VALUES
	 ('2022-03-24 11:35:12','标题1','工号1','姓名1','部门1','正常','缺勤次数1','备注1','2022-03-24'),
	 ('2022-03-24 11:35:12','标题2','工号2','姓名2','部门2','正常','缺勤次数2','备注2','2022-03-24'),
	 ('2022-03-24 11:35:12','标题3','工号3','姓名3','部门3','正常','缺勤次数3','备注3','2022-03-24'),
	 ('2022-03-24 11:35:12','标题4','工号4','姓名4','部门4','正常','缺勤次数4','备注4','2022-03-24'),
	 ('2022-03-24 11:35:12','标题5','工号5','姓名5','部门5','正常','缺勤次数5','备注5','2022-03-24'),
	 ('2022-03-24 11:35:12','标题6','工号6','姓名6','部门6','正常','缺勤次数6','备注6','2022-03-24');INSERT INTO djangoar13x.lizhixinxi (addtime,mingcheng,cizhiriqi,liyou,cizhibiao,gonghao,xingming,bumen,sfsh,shhf) VALUES
	 ('2022-03-24 11:35:12','名称1','2022-03-24','理由1','','工号1','姓名1','部门1','是',''),
	 ('2022-03-24 11:35:12','名称2','2022-03-24','理由2','','工号2','姓名2','部门2','是',''),
	 ('2022-03-24 11:35:12','名称3','2022-03-24','理由3','','工号3','姓名3','部门3','是',''),
	 ('2022-03-24 11:35:12','名称4','2022-03-24','理由4','','工号4','姓名4','部门4','是',''),
	 ('2022-03-24 11:35:12','名称5','2022-03-24','理由5','','工号5','姓名5','部门5','是',''),
	 ('2022-03-24 11:35:12','名称6','2022-03-24','理由6','','工号6','姓名6','部门6','是','');INSERT INTO djangoar13x.qingjiaxinxi (addtime,mingcheng,qingjiariqi,qingjiatianshu,qingjianeirong,gonghao,xingming,bumen,sfsh,shhf) VALUES
	 ('2022-03-24 11:35:12','名称1','2022-03-24','请假天数1','请假内容1','工号1','姓名1','部门1','是',''),
	 ('2022-03-24 11:35:12','名称2','2022-03-24','请假天数2','请假内容2','工号2','姓名2','部门2','是',''),
	 ('2022-03-24 11:35:12','名称3','2022-03-24','请假天数3','请假内容3','工号3','姓名3','部门3','是',''),
	 ('2022-03-24 11:35:12','名称4','2022-03-24','请假天数4','请假内容4','工号4','姓名4','部门4','是',''),
	 ('2022-03-24 11:35:12','名称5','2022-03-24','请假天数5','请假内容5','工号5','姓名5','部门5','是',''),
	 ('2022-03-24 11:35:12','名称6','2022-03-24','请假天数6','请假内容6','工号6','姓名6','部门6','是','');INSERT INTO djangoar13x.renshidiaodong (addtime,mingcheng,riqi,gonghao,bumen,xingming,diaodongneirong) VALUES
	 ('2022-03-24 11:35:12','名称1','2022-03-24','工号1','部门1','姓名1','调动内容1'),
	 ('2022-03-24 11:35:12','名称2','2022-03-24','工号2','部门2','姓名2','调动内容2'),
	 ('2022-03-24 11:35:12','名称3','2022-03-24','工号3','部门3','姓名3','调动内容3'),
	 ('2022-03-24 11:35:12','名称4','2022-03-24','工号4','部门4','姓名4','调动内容4'),
	 ('2022-03-24 11:35:12','名称5','2022-03-24','工号5','部门5','姓名5','调动内容5'),
	 ('2022-03-24 11:35:12','名称6','2022-03-24','工号6','部门6','姓名6','调动内容6');INSERT INTO djangoar13x.renyuandangan (addtime,danganbianhao,mingcheng,gonghao,xingming,xingbie,nianling,bumen,dengji,gongling,dianhua,zhuzhi,ruzhiriqi,shengzhidiaodong,beizhu,dengjiriqi) VALUES
	 ('2022-03-24 11:35:12','档案编号1','名称1','工号1','姓名1','性别1','年龄1','部门1','等级1','工龄1','电话1','住址1','2022-03-24','升职调动1','备注1','2022-03-24'),
	 ('2022-03-24 11:35:12','档案编号2','名称2','工号2','姓名2','性别2','年龄2','部门2','等级2','工龄2','电话2','住址2','2022-03-24','升职调动2','备注2','2022-03-24'),
	 ('2022-03-24 11:35:12','档案编号3','名称3','工号3','姓名3','性别3','年龄3','部门3','等级3','工龄3','电话3','住址3','2022-03-24','升职调动3','备注3','2022-03-24'),
	 ('2022-03-24 11:35:12','档案编号4','名称4','工号4','姓名4','性别4','年龄4','部门4','等级4','工龄4','电话4','住址4','2022-03-24','升职调动4','备注4','2022-03-24'),
	 ('2022-03-24 11:35:12','档案编号5','名称5','工号5','姓名5','性别5','年龄5','部门5','等级5','工龄5','电话5','住址5','2022-03-24','升职调动5','备注5','2022-03-24'),
	 ('2022-03-24 11:35:12','档案编号6','名称6','工号6','姓名6','性别6','年龄6','部门6','等级6','工龄6','电话6','住址6','2022-03-24','升职调动6','备注6','2022-03-24');INSERT INTO djangoar13x.shangbandaka (addtime,mingcheng,shangbanshijian,xiabanshijian,gonghao,xingming,bumen) VALUES
	 ('2022-03-24 11:35:12','名称1','2022-03-24 11:35:12','2022-03-24 11:35:12','工号1','姓名1','部门1'),
	 ('2022-03-24 11:35:12','名称2','2022-03-24 11:35:12','2022-03-24 11:35:12','工号2','姓名2','部门2'),
	 ('2022-03-24 11:35:12','名称3','2022-03-24 11:35:12','2022-03-24 11:35:12','工号3','姓名3','部门3'),
	 ('2022-03-24 11:35:12','名称4','2022-03-24 11:35:12','2022-03-24 11:35:12','工号4','姓名4','部门4'),
	 ('2022-03-24 11:35:12','名称5','2022-03-24 11:35:12','2022-03-24 11:35:12','工号5','姓名5','部门5'),
	 ('2022-03-24 11:35:12','名称6','2022-03-24 11:35:12','2022-03-24 11:35:12','工号6','姓名6','部门6');INSERT INTO djangoar13x.users (username,password,`role`,addtime) VALUES
	 ('abo','abo','管理员','2022-03-24 11:35:12');INSERT INTO djangoar13x.yuangong (addtime,gonghao,mima,xingming,xingbie,nianling,touxiang,bumen,dianhua,zhuzhi) VALUES
	 ('2022-03-24 11:35:12','001','001','姓名1','男','年龄1','http://localhost:8080/djangoar13x/upload/yuangong_touxiang1.jpg','部门1','13823888881','住址1'),
	 ('2022-03-24 11:35:12','员工2','123456','姓名2','男','年龄2','http://localhost:8080/djangoar13x/upload/yuangong_touxiang2.jpg','部门2','13823888882','住址2'),
	 ('2022-03-24 11:35:12','员工3','123456','姓名3','男','年龄3','http://localhost:8080/djangoar13x/upload/yuangong_touxiang3.jpg','部门3','13823888883','住址3'),
	 ('2022-03-24 11:35:12','员工4','123456','姓名4','男','年龄4','http://localhost:8080/djangoar13x/upload/yuangong_touxiang4.jpg','部门4','13823888884','住址4'),
	 ('2022-03-24 11:35:12','员工5','123456','姓名5','男','年龄5','http://localhost:8080/djangoar13x/upload/yuangong_touxiang5.jpg','部门5','13823888885','住址5'),
	 ('2022-03-24 11:35:12','员工6','123456','姓名6','男','年龄6','http://localhost:8080/djangoar13x/upload/yuangong_touxiang6.jpg','部门6','13823888886','住址6'),
	 ('2022-03-31 21:51:31','test2022','test2022','test2022','男','19','http://localhost:8080/djangoar13x/upload/1648734677013.jpeg','部门名称4','13888888888','北京市');